/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.core.tunneling;

import com.aptana.core.logging.IdeLog;
import com.aptana.php.debug.PHPDebugPlugin;
import com.aptana.php.debug.core.tunneling.SSHTunnel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;

public class SSHTunnelFactory {
    private static final String LOCALHOST = "localhost";
    private static Map<SSHTunnel, SSHTunnel> tunnels = new HashMap<SSHTunnel, SSHTunnel>();

    public static SSHTunnel getSSHTunnel(String remoteHost, String userName, String password, int localPort, int remotePort, boolean cacheTunnel) {
        SSHTunnel tunnel = SSHTunnelFactory.createSSHTunnel(remoteHost, userName, password, localPort, remotePort);
        if (cacheTunnel) {
            if (tunnels.containsKey(tunnel)) {
                tunnel = tunnels.get(tunnel);
            } else {
                tunnels.put(tunnel, tunnel);
            }
        }
        return tunnel;
    }

    public static SSHTunnel getSSHTunnel(String remoteHost, String userName, String password, int localPort, int remotePort) {
        return SSHTunnelFactory.getSSHTunnel(remoteHost, userName, password, localPort, remotePort, true);
    }

    public static boolean hasSSHTunnel(String remoteHost, String userName, String password, int localPort, int remotePort) {
        SSHTunnel tunnel = SSHTunnelFactory.createSSHTunnel(remoteHost, userName, password, localPort, remotePort);
        return tunnels.containsKey(tunnel);
    }

    private static SSHTunnel createSSHTunnel(String remoteHost, String userName, String password, int localPort, int remotePort) {
        String localHost = LOCALHOST;
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            IdeLog.logError((Plugin)PHPDebugPlugin.getDefault(), (String)"Unknown host", (Throwable)e, (String)"com.aptana.php.debug/debug");
        }
        SSHTunnel tunnel = new SSHTunnel(localHost, remoteHost, userName, password, localPort, remotePort);
        return tunnel;
    }

    public static void closeAllConnections() {
        for (SSHTunnel tunnel : tunnels.values()) {
            tunnel.disconnect();
        }
    }

    public static List<SSHTunnel> getAllTunnels() {
        return Collections.unmodifiableList(Arrays.asList(tunnels.values().toArray(new SSHTunnel[tunnels.size()])));
    }
}

